"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.UsersService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
const bcrypt = __importStar(require("bcrypt"));
const user_entity_1 = require("./entities/user.entity");
const PASSWORD_EXPIRY_DAYS = 90;
let UsersService = class UsersService {
    usersRepository;
    constructor(usersRepository) {
        this.usersRepository = usersRepository;
    }
    async create(createUserDto) {
        const normalizedEmail = this.normalizeEmail(createUserDto.email);
        const existingUser = await this.usersRepository.findOne({
            where: { email: normalizedEmail },
        });
        if (existingUser) {
            throw new common_1.ConflictException('Энэ и-мэйл аль хэдийн бүртгэлтэй байна.');
        }
        const hashedPassword = await bcrypt.hash(createUserDto.password, 12);
        const { password, ...rest } = createUserDto;
        const now = new Date();
        const user = this.usersRepository.create({
            ...rest,
            email: normalizedEmail,
            password: hashedPassword,
            passwordChangedAt: now,
            passwordExpiresAt: this.calculatePasswordExpiry(now),
        });
        return this.usersRepository.save(user);
    }
    findAll() {
        return this.usersRepository.find({ order: { createdAt: 'DESC' } });
    }
    async findOne(id) {
        const user = await this.usersRepository.findOne({ where: { id } });
        if (!user) {
            throw new common_1.NotFoundException('Хэрэглэгч олдсонгүй.');
        }
        return user;
    }
    async findByEmail(email) {
        return this.usersRepository.findOne({
            where: { email: this.normalizeEmail(email) },
        });
    }
    async update(id, updateUserDto) {
        const user = await this.findOne(id);
        if (updateUserDto.email && updateUserDto.email !== user.email) {
            const normalizedEmail = this.normalizeEmail(updateUserDto.email);
            const existing = await this.findByEmail(normalizedEmail);
            if (existing && existing.id !== id) {
                throw new common_1.ConflictException('Энэ и-мэйл аль хэдийн ашиглагдаж байна.');
            }
            user.email = normalizedEmail;
        }
        if (updateUserDto.password) {
            user.password = await bcrypt.hash(updateUserDto.password, 12);
            user.passwordChangedAt = new Date();
            user.passwordExpiresAt = this.calculatePasswordExpiry(user.passwordChangedAt);
        }
        if (typeof updateUserDto.firstName === 'string')
            user.firstName = updateUserDto.firstName;
        if (typeof updateUserDto.lastName === 'string')
            user.lastName = updateUserDto.lastName;
        if (typeof updateUserDto.phone === 'string')
            user.phone = updateUserDto.phone;
        if (typeof updateUserDto.rank === 'string')
            user.rank = updateUserDto.rank;
        if (typeof updateUserDto.unit === 'string')
            user.unit = updateUserDto.unit;
        if (typeof updateUserDto.role !== 'undefined')
            user.role = updateUserDto.role;
        if (typeof updateUserDto.isActive === 'boolean')
            user.isActive = updateUserDto.isActive;
        return this.usersRepository.save(user);
    }
    async deactivate(id) {
        const user = await this.findOne(id);
        user.isActive = false;
        return this.usersRepository.save(user);
    }
    normalizeEmail(email) {
        return email.trim().toLowerCase();
    }
    calculatePasswordExpiry(from) {
        const expiry = new Date(from);
        expiry.setDate(expiry.getDate() + PASSWORD_EXPIRY_DAYS);
        return expiry;
    }
};
exports.UsersService = UsersService;
exports.UsersService = UsersService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(user_entity_1.User)),
    __metadata("design:paramtypes", [typeorm_2.Repository])
], UsersService);
//# sourceMappingURL=users.service.js.map