"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SettingsService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
const system_setting_entity_1 = require("./entities/system-setting.entity");
const DEFAULT_SETTINGS = {
    brandingLogoUrl: null,
    timezone: 'UTC+08',
    autoLockMinutes: 10,
    enableTwoFactor: true,
    emailAlerts: true,
    smsAlerts: false,
    dataRetention: 180,
    defaultMapLayer: 'district',
    loginAttempts: 5,
    passwordRotationDays: 90,
    officialEmail: 'info@nalaikh.police.mn',
};
let SettingsService = class SettingsService {
    settingsRepository;
    constructor(settingsRepository) {
        this.settingsRepository = settingsRepository;
    }
    async getSettings() {
        const records = await this.settingsRepository.find();
        const settings = { ...DEFAULT_SETTINGS };
        const target = settings;
        for (const record of records) {
            if (!Object.prototype.hasOwnProperty.call(DEFAULT_SETTINGS, record.key)) {
                continue;
            }
            if (typeof record.value === 'undefined') {
                continue;
            }
            target[record.key] = record.value;
        }
        return settings;
    }
    async getPublicSettings() {
        const { brandingLogoUrl } = await this.getSettings();
        return { brandingLogoUrl };
    }
    async updateSettings(update) {
        const entries = Object.entries(update).filter(([, value]) => value !== undefined);
        if (!entries.length) {
            return this.getSettings();
        }
        const upsertPayload = entries.map(([key, value]) => ({
            key,
            value: value ?? null,
        }));
        await this.settingsRepository.upsert(upsertPayload, ['key']);
        return this.getSettings();
    }
};
exports.SettingsService = SettingsService;
exports.SettingsService = SettingsService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(system_setting_entity_1.SystemSetting)),
    __metadata("design:paramtypes", [typeorm_2.Repository])
], SettingsService);
//# sourceMappingURL=settings.service.js.map