import { Repository } from 'typeorm';
import { SystemSetting } from './entities/system-setting.entity';
import { UpdateSettingsDto } from './dto/update-settings.dto';
export interface SystemSettings {
    brandingLogoUrl: string | null;
    timezone: string;
    autoLockMinutes: number;
    enableTwoFactor: boolean;
    emailAlerts: boolean;
    smsAlerts: boolean;
    dataRetention: number;
    defaultMapLayer: string;
    loginAttempts: number;
    passwordRotationDays: number;
    officialEmail?: string;
}
export declare class SettingsService {
    private readonly settingsRepository;
    constructor(settingsRepository: Repository<SystemSetting>);
    getSettings(): Promise<SystemSettings>;
    getPublicSettings(): Promise<Pick<SystemSettings, 'brandingLogoUrl'>>;
    updateSettings(update: UpdateSettingsDto): Promise<SystemSettings>;
}
