"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@nestjs/core");
const common_1 = require("@nestjs/common");
const app_module_1 = require("../app.module");
const users_service_1 = require("../users/users.service");
const user_role_enum_1 = require("../users/enums/user-role.enum");
async function bootstrap() {
    const logger = new common_1.Logger('SeedAdmin');
    const appContext = await core_1.NestFactory.createApplicationContext(app_module_1.AppModule, {
        logger: ['error', 'log', 'warn'],
    });
    try {
        const usersService = appContext.get(users_service_1.UsersService);
        const email = process.env.SEED_ADMIN_EMAIL ?? 'admin@nalaikh.police.mn';
        const password = process.env.SEED_ADMIN_PASSWORD ?? 'StrongPass!123';
        const firstName = process.env.SEED_ADMIN_FIRST_NAME ?? 'Админ';
        const lastName = process.env.SEED_ADMIN_LAST_NAME ?? 'Хэрэглэгч';
        const existingUser = await usersService.findByEmail(email);
        if (existingUser) {
            logger.log(`Админ хэрэглэгч (${email}) аль хэдийн бий.`);
            return;
        }
        await usersService.create({
            email,
            password,
            firstName,
            lastName,
            role: user_role_enum_1.UserRole.ADMIN,
        });
        logger.log(`Админ хэрэглэгч (${email}) амжилттай үүсгэлээ.`);
    }
    catch (error) {
        logger.error('Админ үүсгэх явцад алдаа гарлаа', error);
        process.exitCode = 1;
    }
    finally {
        await appContext.close();
    }
}
void bootstrap();
//# sourceMappingURL=seed-admin.js.map