"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.FrequentCallersService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
const XLSX = __importStar(require("xlsx"));
const frequent_caller_entity_1 = require("./entities/frequent-caller.entity");
const frequent_caller_type_enum_1 = require("./enums/frequent-caller-type.enum");
const frequent_caller_gender_enum_1 = require("./enums/frequent-caller-gender.enum");
let FrequentCallersService = class FrequentCallersService {
    frequentCallersRepository;
    constructor(frequentCallersRepository) {
        this.frequentCallersRepository = frequentCallersRepository;
    }
    async create(createFrequentCallerDto) {
        if (createFrequentCallerDto.callerType === frequent_caller_type_enum_1.FrequentCallerType.CITIZEN) {
            const normalizedRegistration = this.normalizeRegistration(createFrequentCallerDto.registrationNumber);
            if (normalizedRegistration) {
                const existing = await this.frequentCallersRepository.findOne({
                    where: {
                        callerType: frequent_caller_type_enum_1.FrequentCallerType.CITIZEN,
                        registrationNumber: normalizedRegistration,
                    },
                });
                if (existing) {
                    existing.callFrequency = (existing.callFrequency ?? 0) + 1;
                    Object.assign(existing, createFrequentCallerDto, {
                        registrationNumber: normalizedRegistration,
                        callFrequency: existing.callFrequency,
                    });
                    return this.frequentCallersRepository.save(existing);
                }
                createFrequentCallerDto.registrationNumber = normalizedRegistration;
            }
            if (!createFrequentCallerDto.callFrequency || createFrequentCallerDto.callFrequency < 1) {
                createFrequentCallerDto.callFrequency = 1;
            }
        }
        const entity = this.frequentCallersRepository.create({
            crimeCallCount: 0,
            incidentCallCount: 0,
            complaintCount: 0,
            hasIssue: false,
            ...createFrequentCallerDto,
        });
        return this.frequentCallersRepository.save(entity);
    }
    findAll(filter) {
        const where = {};
        if (filter?.type) {
            where.callerType = filter.type;
        }
        return this.frequentCallersRepository.find({
            where,
            order: { name: 'ASC' },
        });
    }
    async findOne(id) {
        const entity = await this.frequentCallersRepository.findOne({ where: { id } });
        if (!entity) {
            throw new common_1.NotFoundException('Бүртгэл олдсонгүй.');
        }
        return entity;
    }
    async update(id, updateFrequentCallerDto) {
        const entity = await this.findOne(id);
        Object.assign(entity, updateFrequentCallerDto);
        return this.frequentCallersRepository.save(entity);
    }
    async remove(id) {
        const entity = await this.findOne(id);
        await this.frequentCallersRepository.remove(entity);
        return { deleted: true };
    }
    async removeMany(filter) {
        const where = {};
        if (filter?.type) {
            where.callerType = filter.type;
        }
        const result = await this.frequentCallersRepository.delete(where);
        return { deleted: result.affected ?? 0 };
    }
    async importFromExcel(buffer, defaultType) {
        const workbook = XLSX.read(buffer, { type: 'buffer' });
        const sheet = workbook.Sheets[workbook.SheetNames[0]];
        if (!sheet) {
            return { imported: 0 };
        }
        const rawRows = XLSX.utils.sheet_to_json(sheet, {
            defval: null,
            raw: false,
            blankrows: false,
            dateNF: 'yyyy-mm-dd',
        });
        const validRows = rawRows
            .map((row) => this.mapRowToDto(row, defaultType))
            .filter((row) => Boolean(row));
        if (!validRows.length) {
            return { imported: 0 };
        }
        const entities = this.frequentCallersRepository.create(validRows);
        await this.frequentCallersRepository.save(entities);
        return { imported: entities.length };
    }
    async exportAsExcel(filter) {
        const workbook = XLSX.utils.book_new();
        const rows = filter.template
            ? this.getTemplateRows(filter.type)
            : await this.findAll({ type: filter.type });
        const aoa = this.buildSheetData(rows, filter.type);
        const sheet = XLSX.utils.aoa_to_sheet(aoa);
        XLSX.utils.book_append_sheet(workbook, sheet, filter.type === frequent_caller_type_enum_1.FrequentCallerType.ORGANIZATION
            ? 'Байгууллагууд'
            : 'Иргэд');
        return XLSX.write(workbook, { type: 'buffer', bookType: 'xlsx' });
    }
    buildSheetData(data, type) {
        if (type === frequent_caller_type_enum_1.FrequentCallerType.ORGANIZATION) {
            const header = [
                'Нэр',
                'Төрөл',
                'Бүртгэлийн дугаар',
                'Удирдагч',
                'Утас',
                'И-мэйл',
                'Хаяг',
                'Хороо',
                'Гэмт хэргийн дуудлага',
                'Зөрчлийн дуудлага',
                'Гомдлын тоо',
                'Асуудалтай эсэх',
                'Тэмдэглэл',
            ];
            const rows = data.map((item) => [
                item.name ?? '',
                item.organizationCategory ?? '',
                item.registrationNumber ?? '',
                item.contactName ?? '',
                item.phone ?? '',
                item.email ?? '',
                item.address ?? '',
                item.khoroo ?? '',
                item.crimeCallCount ?? 0,
                item.incidentCallCount ?? 0,
                item.complaintCount ?? 0,
                item.hasIssue ? 'Тийм' : 'Үгүй',
                item.notes ?? '',
            ]);
            return [header, ...rows];
        }
        const header = [
            'Бүтэн нэр',
            'Овог',
            'Нэр',
            'Бүртгэлийн төрөл',
            'Бүртгэлийн дугаар',
            'Төрсөн он, сар, өдөр',
            'Хүйс',
            'Зураг',
            'Холбогдох хүн',
            'Утас',
            'И-мэйл',
            'Хаяг',
            'Хороо',
            'Дуудлагын давтамж',
            'Гэмт хэргийн дуудлага',
            'Зөрчлийн дуудлага',
            'Гомдлын тоо',
            'Ял шийтгэл',
            'Захиргааны зөрчил',
            'Зөрчлийн төрөл',
            'Дахин дуудлага / арга хэмжээ',
            'Асуудалтай эсэх',
            'Тэмдэглэл',
        ];
        const rows = data.map((item) => [
            item.name ?? '',
            item.lastName ?? '',
            item.firstName ?? '',
            this.formatCallerType(item.callerType),
            item.registrationNumber ?? '',
            this.formatDateValue(item.birthDate),
            this.formatGender(item.gender),
            item.photoUrl ?? '',
            item.contactName ?? '',
            item.phone ?? '',
            item.email ?? '',
            item.address ?? '',
            item.khoroo ?? '',
            item.callFrequency ?? 1,
            item.crimeCallCount ?? 0,
            item.incidentCallCount ?? 0,
            item.complaintCount ?? 0,
            item.convictionHistory ?? '',
            item.adminViolationHistory ?? '',
            item.violationType ?? '',
            item.followUpAction ?? '',
            item.hasIssue ? 'Тийм' : 'Үгүй',
            item.notes ?? '',
        ]);
        return [header, ...rows];
    }
    mapRowToDto(row, defaultType) {
        const normalizedKeys = Object.keys(row).reduce((acc, key) => {
            acc[key.trim().toLowerCase()] = row[key];
            return acc;
        }, {});
        const nameCell = this.getString(normalizedKeys['нэр'] ?? normalizedKeys['name']);
        const fullNameCell = this.getString(normalizedKeys['бүтэн нэр'] ?? normalizedKeys['full name']);
        const fullName = fullNameCell ?? nameCell;
        const lastName = this.getString(normalizedKeys['овог']) ??
            this.getString(normalizedKeys['lastname']) ??
            this.getString(normalizedKeys['last name']);
        let firstName = this.getString(normalizedKeys['өөрийн нэр']) ??
            this.getString(normalizedKeys['firstname']) ??
            this.getString(normalizedKeys['first name']) ??
            this.getString(normalizedKeys['given name']) ??
            (fullNameCell ? nameCell : undefined) ??
            (!lastName ? nameCell : undefined);
        const composedName = fullName ||
            [lastName, firstName]
                .filter((value) => Boolean(value && value.length))
                .join(' ')
                .trim();
        if (!composedName) {
            return null;
        }
        const callerType = this.parseCallerType(normalizedKeys['төрөл'] ??
            normalizedKeys['type'] ??
            normalizedKeys['бүртгэлийн төрөл'], defaultType);
        if (!callerType) {
            return null;
        }
        let derivedLastName = lastName;
        if (!derivedLastName && callerType === frequent_caller_type_enum_1.FrequentCallerType.CITIZEN) {
            const [firstPart] = composedName.split(/\s+/);
            derivedLastName = firstPart || undefined;
        }
        if (!firstName && callerType === frequent_caller_type_enum_1.FrequentCallerType.CITIZEN) {
            const parts = composedName.split(/\s+/);
            if (parts.length > 1) {
                firstName = parts.slice(1).join(' ');
            }
            if (!firstName && derivedLastName && composedName !== derivedLastName) {
                firstName = composedName;
            }
        }
        const organizationCategory = this.getString(normalizedKeys['байгууллагын төрөл']) ??
            this.getString(normalizedKeys['төрөл']) ??
            this.getString(normalizedKeys['ангилал']) ??
            this.getString(normalizedKeys['category']) ??
            undefined;
        if (callerType === frequent_caller_type_enum_1.FrequentCallerType.ORGANIZATION && !organizationCategory) {
            return null;
        }
        const birthDate = this.parseDateInput(normalizedKeys['төрсөн он, сар, өдөр'] ??
            normalizedKeys['төрсөн он сар өдөр'] ??
            normalizedKeys['төрсөн он'] ??
            normalizedKeys['төрсөн огноо'] ??
            normalizedKeys['birthdate'] ??
            normalizedKeys['birth date']);
        const gender = this.parseGender(normalizedKeys['хүйс'] ?? normalizedKeys['gender']);
        return {
            name: composedName,
            callerType,
            organizationCategory: callerType === frequent_caller_type_enum_1.FrequentCallerType.ORGANIZATION
                ? organizationCategory ?? undefined
                : undefined,
            lastName: callerType === frequent_caller_type_enum_1.FrequentCallerType.CITIZEN ? derivedLastName ?? undefined : undefined,
            firstName: callerType === frequent_caller_type_enum_1.FrequentCallerType.CITIZEN ? firstName ?? undefined : undefined,
            birthDate: callerType === frequent_caller_type_enum_1.FrequentCallerType.CITIZEN ? birthDate : undefined,
            gender: callerType === frequent_caller_type_enum_1.FrequentCallerType.CITIZEN ? gender : undefined,
            registrationNumber: this.getString(normalizedKeys['бүртгэлийн дугаар']) ??
                this.getString(normalizedKeys['регистер']) ??
                this.getString(normalizedKeys['register']) ??
                undefined,
            photoUrl: this.getString(normalizedKeys['зураг']) ??
                this.getString(normalizedKeys['image']) ??
                this.getString(normalizedKeys['photo']) ??
                undefined,
            contactName: this.getString(normalizedKeys['удирдагч']) ??
                this.getString(normalizedKeys['холбогдох хүн']) ??
                this.getString(normalizedKeys['leader']) ??
                this.getString(normalizedKeys['contact']) ??
                undefined,
            phone: this.getString(normalizedKeys['утас']) ?? undefined,
            email: this.getString(normalizedKeys['и-мэйл']) ?? this.getString(normalizedKeys['email']) ?? undefined,
            address: this.getString(normalizedKeys['хаяг']) ?? undefined,
            khoroo: this.getString(normalizedKeys['хороо']) ?? undefined,
            crimeCallCount: this.getNumber(normalizedKeys['гэмт хэргийн дуудлага'] ?? normalizedKeys['crime calls']),
            incidentCallCount: this.getNumber(normalizedKeys['зөрчлийн дуудлага'] ?? normalizedKeys['incident calls']),
            complaintCount: this.getNumber(normalizedKeys['гомдлын тоо'] ?? normalizedKeys['complaints']),
            callFrequency: this.normalizeCallFrequency(normalizedKeys['дуудлагын давтамж'] ?? normalizedKeys['call frequency']),
            hasIssue: this.getBoolean(normalizedKeys['асуудалтай'] ?? normalizedKeys['problematic']),
            notes: this.getString(normalizedKeys['тэмдэглэл']) ?? undefined,
        };
    }
    formatCallerType(type) {
        if (type === frequent_caller_type_enum_1.FrequentCallerType.ORGANIZATION) {
            return 'Байгууллага';
        }
        return 'Иргэн';
    }
    parseCallerType(value, fallback) {
        if (!value && fallback) {
            return fallback;
        }
        const normalized = this.getString(value)?.toLowerCase();
        if (!normalized) {
            return fallback;
        }
        if (['citizen', 'иргэн', 'individual'].includes(normalized)) {
            return frequent_caller_type_enum_1.FrequentCallerType.CITIZEN;
        }
        if (['organization', 'байгууллага', 'company', 'institution'].includes(normalized)) {
            return frequent_caller_type_enum_1.FrequentCallerType.ORGANIZATION;
        }
        return fallback;
    }
    getString(value) {
        if (value === null || value === undefined) {
            return undefined;
        }
        const stringValue = String(value).trim();
        return stringValue.length ? stringValue : undefined;
    }
    getNumber(value) {
        const num = Number(value);
        return Number.isFinite(num) && num >= 0 ? num : 0;
    }
    getBoolean(value) {
        if (typeof value === 'boolean') {
            return value;
        }
        const normalized = this.getString(value)?.toLowerCase();
        return normalized ? ['тийм', 'тйм', 'yes', 'true', 'problem'].includes(normalized) : false;
    }
    normalizeRegistration(value) {
        if (!value) {
            return undefined;
        }
        return value.replace(/\s+/g, '').toUpperCase();
    }
    getTemplateRows(type) {
        if (type === frequent_caller_type_enum_1.FrequentCallerType.ORGANIZATION) {
            return [
                {
                    name: 'Жишиг ДАНБ 1',
                    callerType: frequent_caller_type_enum_1.FrequentCallerType.ORGANIZATION,
                    organizationCategory: 'Бар',
                    registrationNumber: '1234567',
                    photoUrl: 'https://images.example.com/org-1.jpg',
                    contactName: 'Б.Болд',
                    phone: '99001122',
                    email: 'example@aanb.mn',
                    address: 'Налайх дүүрэг, 1-р хороо',
                    khoroo: '1-р хороо',
                    crimeCallCount: 4,
                    incidentCallCount: 12,
                    complaintCount: 3,
                    hasIssue: true,
                    notes: 'Шөнө орой дуудлага олон ирдэг',
                },
                {
                    name: 'Жишиг ДАНБ 2',
                    callerType: frequent_caller_type_enum_1.FrequentCallerType.ORGANIZATION,
                    organizationCategory: 'Зочид буудал',
                    registrationNumber: '7654321',
                    photoUrl: 'https://images.example.com/org-2.jpg',
                    contactName: 'Д.Оюун',
                    phone: '99112233',
                    email: 'aanb2@example.mn',
                    address: 'Налайх дүүрэг, 2-р хороо',
                    khoroo: '2-р хороо',
                    crimeCallCount: 4,
                    incidentCallCount: 15,
                    complaintCount: 2,
                    hasIssue: false,
                    notes: 'Хяналтын камер суурилуулж байгаа',
                },
                {
                    name: 'Жишиг зочид буудал',
                    callerType: frequent_caller_type_enum_1.FrequentCallerType.ORGANIZATION,
                    organizationCategory: 'Ресторан',
                    registrationNumber: '5551234',
                    photoUrl: 'https://images.example.com/org-3.jpg',
                    contactName: 'С.Сайхан',
                    phone: '99223344',
                    email: 'hotel@example.mn',
                    address: 'Налайх дүүрэг, 3-р хороо',
                    khoroo: '3-р хороо',
                    crimeCallCount: 2,
                    incidentCallCount: 8,
                    complaintCount: 1,
                    hasIssue: true,
                    notes: 'Үйлчилгээний чанартай холбоотой гомдол өссөн',
                },
            ];
        }
        return [
            {
                name: 'Д.Бат-Эрдэнэ',
                lastName: 'Дамдин',
                firstName: 'Бат-Эрдэнэ',
                birthDate: '1984-02-18',
                gender: frequent_caller_gender_enum_1.FrequentCallerGender.MALE,
                callerType: frequent_caller_type_enum_1.FrequentCallerType.CITIZEN,
                registrationNumber: 'УК99112233',
                photoUrl: 'https://images.example.com/person-1.jpg',
                contactName: 'Ц.Бямба',
                phone: '99112233',
                email: 'citizen1@example.mn',
                address: 'Налайх дүүрэг, 4-р хороо',
                khoroo: '4-р хороо',
                callFrequency: 3,
                crimeCallCount: 2,
                incidentCallCount: 6,
                complaintCount: 1,
                convictionHistory: '2019 онд нэг удаагийн ял шийтгэлтэй',
                adminViolationHistory: '2023 онд захиргааны арга хэмжээ авч байсан',
                violationType: 'Гэр бүлийн хүчирхийлэл',
                followUpAction: 'Сэтгэл зүйн зөвлөгөө өгч байгаа',
                hasIssue: true,
                notes: 'Тогтмол хяналт шаардана',
            },
            {
                name: 'С.Оюунгэрэл',
                lastName: 'Сумъяа',
                firstName: 'Оюунгэрэл',
                birthDate: '1976-11-05',
                gender: frequent_caller_gender_enum_1.FrequentCallerGender.FEMALE,
                callerType: frequent_caller_type_enum_1.FrequentCallerType.CITIZEN,
                registrationNumber: 'УИ88114455',
                photoUrl: 'https://images.example.com/person-2.jpg',
                contactName: 'Н.Эрдэнэ',
                phone: '98119944',
                email: 'citizen2@example.mn',
                address: 'Налайх дүүрэг, 5-р хороо',
                khoroo: '5-р хороо',
                callFrequency: 2,
                crimeCallCount: 1,
                incidentCallCount: 4,
                complaintCount: 0,
                convictionHistory: 'Ял шийтгэл байхгүй',
                adminViolationHistory: 'Захиргааны зөрчил нэг удаа',
                violationType: 'Нийгмийн хэв журам',
                followUpAction: 'Иргэний зөвлөлтэй хамтарч ажиллаж байгаа',
                hasIssue: false,
                notes: 'Өндөр настай, эрүүл мэндийн асуудалтай',
            },
        ];
    }
    formatDateValue(value) {
        if (!value) {
            return '';
        }
        if (value instanceof Date) {
            return value.toISOString().split('T')[0];
        }
        const stringValue = this.getString(value);
        if (!stringValue) {
            return '';
        }
        const normalized = stringValue.replace(/[./]/g, '-');
        const parsed = new Date(normalized);
        if (!Number.isNaN(parsed.getTime())) {
            return parsed.toISOString().split('T')[0];
        }
        return stringValue;
    }
    parseDateInput(value) {
        if (value instanceof Date) {
            return value.toISOString().split('T')[0];
        }
        if (typeof value === 'number' && Number.isFinite(value)) {
            const date = XLSX.SSF.parse_date_code(value);
            if (date) {
                const yyyy = String(date.y).padStart(4, '0');
                const mm = String(date.m).padStart(2, '0');
                const dd = String(date.d).padStart(2, '0');
                return `${yyyy}-${mm}-${dd}`;
            }
        }
        const stringValue = this.getString(value);
        if (!stringValue) {
            return undefined;
        }
        const normalized = stringValue.replace(/[./]/g, '-');
        const parsed = new Date(normalized);
        if (Number.isNaN(parsed.getTime())) {
            return undefined;
        }
        return parsed.toISOString().split('T')[0];
    }
    parseGender(value) {
        const normalized = this.getString(value)?.toLowerCase();
        if (!normalized) {
            return undefined;
        }
        if (['эрэгтэй', 'male', 'm'].includes(normalized)) {
            return frequent_caller_gender_enum_1.FrequentCallerGender.MALE;
        }
        if (['эмэгтэй', 'female', 'f'].includes(normalized)) {
            return frequent_caller_gender_enum_1.FrequentCallerGender.FEMALE;
        }
        return undefined;
    }
    formatGender(value) {
        if (value === frequent_caller_gender_enum_1.FrequentCallerGender.MALE) {
            return 'Эрэгтэй';
        }
        if (value === frequent_caller_gender_enum_1.FrequentCallerGender.FEMALE) {
            return 'Эмэгтэй';
        }
        return '';
    }
    normalizeCallFrequency(value) {
        const parsed = this.getNumber(value);
        return parsed > 0 ? parsed : undefined;
    }
};
exports.FrequentCallersService = FrequentCallersService;
exports.FrequentCallersService = FrequentCallersService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(frequent_caller_entity_1.FrequentCaller)),
    __metadata("design:paramtypes", [typeorm_2.Repository])
], FrequentCallersService);
//# sourceMappingURL=frequent-callers.service.js.map