import { Repository } from 'typeorm';
import { FrequentCaller } from './entities/frequent-caller.entity';
import { CreateFrequentCallerDto } from './dto/create-frequent-caller.dto';
import { UpdateFrequentCallerDto } from './dto/update-frequent-caller.dto';
import { FrequentCallerType } from './enums/frequent-caller-type.enum';
export declare class FrequentCallersService {
    private readonly frequentCallersRepository;
    constructor(frequentCallersRepository: Repository<FrequentCaller>);
    create(createFrequentCallerDto: CreateFrequentCallerDto): Promise<FrequentCaller>;
    findAll(filter?: {
        type?: FrequentCallerType;
    }): Promise<FrequentCaller[]>;
    findOne(id: string): Promise<FrequentCaller>;
    update(id: string, updateFrequentCallerDto: UpdateFrequentCallerDto): Promise<FrequentCaller>;
    remove(id: string): Promise<{
        deleted: boolean;
    }>;
    removeMany(filter?: {
        type?: FrequentCallerType;
    }): Promise<{
        deleted: number;
    }>;
    importFromExcel(buffer: Buffer, defaultType?: FrequentCallerType): Promise<{
        imported: number;
    }>;
    exportAsExcel(filter: {
        type?: FrequentCallerType;
        template?: boolean;
    }): Promise<any>;
    private buildSheetData;
    private mapRowToDto;
    private formatCallerType;
    private parseCallerType;
    private getString;
    private getNumber;
    private getBoolean;
    private normalizeRegistration;
    private getTemplateRows;
    private formatDateValue;
    private parseDateInput;
    private parseGender;
    private formatGender;
    private normalizeCallFrequency;
}
