"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.FrequentCallersController = void 0;
const common_1 = require("@nestjs/common");
const platform_express_1 = require("@nestjs/platform-express");
const frequent_callers_service_1 = require("./frequent-callers.service");
const create_frequent_caller_dto_1 = require("./dto/create-frequent-caller.dto");
const update_frequent_caller_dto_1 = require("./dto/update-frequent-caller.dto");
const jwt_auth_guard_1 = require("../auth/guards/jwt-auth.guard");
const frequent_caller_type_enum_1 = require("./enums/frequent-caller-type.enum");
let FrequentCallersController = class FrequentCallersController {
    frequentCallersService;
    constructor(frequentCallersService) {
        this.frequentCallersService = frequentCallersService;
    }
    create(createFrequentCallerDto) {
        return this.frequentCallersService.create(createFrequentCallerDto);
    }
    findAll(type) {
        return this.frequentCallersService.findAll({
            type: this.normalizeType(type),
        });
    }
    findOne(id) {
        return this.frequentCallersService.findOne(id);
    }
    update(id, updateFrequentCallerDto) {
        return this.frequentCallersService.update(id, updateFrequentCallerDto);
    }
    remove(id) {
        return this.frequentCallersService.remove(id);
    }
    removeMany(type) {
        return this.frequentCallersService.removeMany({
            type: this.normalizeType(type),
        });
    }
    import(file, type) {
        if (!file) {
            throw new common_1.BadRequestException('Excel файл илгээнэ үү.');
        }
        return this.frequentCallersService.importFromExcel(file.buffer, this.normalizeType(type));
    }
    async export(res, type, template) {
        const callerType = this.normalizeType(type);
        const buffer = await this.frequentCallersService.exportAsExcel({
            type: callerType,
            template: template === 'true',
        });
        const timestamp = new Date()
            .toISOString()
            .split('T')[0]
            .replace(/-/g, '');
        const suffix = callerType === frequent_caller_type_enum_1.FrequentCallerType.ORGANIZATION ? 'organizations' : 'citizens';
        const templateSuffix = template === 'true' ? 'template' : 'data';
        const filename = `frequent_callers_${suffix}_${templateSuffix}_${timestamp}.xlsx`;
        res.set({
            'Content-Type': 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet',
            'Content-Disposition': `attachment; filename="${filename}"`,
        });
        res.send(buffer);
    }
    normalizeType(value) {
        if (!value) {
            return undefined;
        }
        const normalized = value.toLowerCase();
        if (['citizen', 'иргэн'].includes(normalized)) {
            return frequent_caller_type_enum_1.FrequentCallerType.CITIZEN;
        }
        if (['organization', 'байгууллага', 'org'].includes(normalized)) {
            return frequent_caller_type_enum_1.FrequentCallerType.ORGANIZATION;
        }
        return undefined;
    }
};
exports.FrequentCallersController = FrequentCallersController;
__decorate([
    (0, common_1.Post)(),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [create_frequent_caller_dto_1.CreateFrequentCallerDto]),
    __metadata("design:returntype", void 0)
], FrequentCallersController.prototype, "create", null);
__decorate([
    (0, common_1.Get)(),
    __param(0, (0, common_1.Query)('type')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], FrequentCallersController.prototype, "findAll", null);
__decorate([
    (0, common_1.Get)(':id'),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], FrequentCallersController.prototype, "findOne", null);
__decorate([
    (0, common_1.Patch)(':id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, update_frequent_caller_dto_1.UpdateFrequentCallerDto]),
    __metadata("design:returntype", void 0)
], FrequentCallersController.prototype, "update", null);
__decorate([
    (0, common_1.Delete)(':id'),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], FrequentCallersController.prototype, "remove", null);
__decorate([
    (0, common_1.Delete)(),
    __param(0, (0, common_1.Query)('type')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], FrequentCallersController.prototype, "removeMany", null);
__decorate([
    (0, common_1.Post)('import'),
    (0, common_1.UseInterceptors)((0, platform_express_1.FileInterceptor)('file')),
    __param(0, (0, common_1.UploadedFile)()),
    __param(1, (0, common_1.Query)('type')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, String]),
    __metadata("design:returntype", void 0)
], FrequentCallersController.prototype, "import", null);
__decorate([
    (0, common_1.Get)('export/file'),
    __param(0, (0, common_1.Res)()),
    __param(1, (0, common_1.Query)('type')),
    __param(2, (0, common_1.Query)('template')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, String, String]),
    __metadata("design:returntype", Promise)
], FrequentCallersController.prototype, "export", null);
exports.FrequentCallersController = FrequentCallersController = __decorate([
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard),
    (0, common_1.Controller)('frequent-callers'),
    __metadata("design:paramtypes", [frequent_callers_service_1.FrequentCallersService])
], FrequentCallersController);
//# sourceMappingURL=frequent-callers.controller.js.map