"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CreateFrequentCallerDto = void 0;
const class_validator_1 = require("class-validator");
const frequent_caller_type_enum_1 = require("../enums/frequent-caller-type.enum");
const frequent_caller_gender_enum_1 = require("../enums/frequent-caller-gender.enum");
class CreateFrequentCallerDto {
    name;
    callerType;
    registrationNumber;
    organizationCategory;
    lastName;
    firstName;
    birthDate;
    gender;
    photoUrl;
    contactName;
    phone;
    email;
    address;
    khoroo;
    callFrequency;
    crimeCallCount;
    incidentCallCount;
    complaintCount;
    convictionHistory;
    adminViolationHistory;
    violationType;
    followUpAction;
    hasIssue;
    notes;
}
exports.CreateFrequentCallerDto = CreateFrequentCallerDto;
__decorate([
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.MaxLength)(255),
    __metadata("design:type", String)
], CreateFrequentCallerDto.prototype, "name", void 0);
__decorate([
    (0, class_validator_1.IsEnum)(frequent_caller_type_enum_1.FrequentCallerType),
    __metadata("design:type", String)
], CreateFrequentCallerDto.prototype, "callerType", void 0);
__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.MaxLength)(50),
    __metadata("design:type", String)
], CreateFrequentCallerDto.prototype, "registrationNumber", void 0);
__decorate([
    (0, class_validator_1.ValidateIf)((input) => input.callerType === frequent_caller_type_enum_1.FrequentCallerType.ORGANIZATION),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsNotEmpty)(),
    (0, class_validator_1.MaxLength)(255),
    __metadata("design:type", String)
], CreateFrequentCallerDto.prototype, "organizationCategory", void 0);
__decorate([
    (0, class_validator_1.ValidateIf)((input) => input.callerType === frequent_caller_type_enum_1.FrequentCallerType.CITIZEN),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsNotEmpty)(),
    (0, class_validator_1.MaxLength)(255),
    __metadata("design:type", String)
], CreateFrequentCallerDto.prototype, "lastName", void 0);
__decorate([
    (0, class_validator_1.ValidateIf)((input) => input.callerType === frequent_caller_type_enum_1.FrequentCallerType.CITIZEN),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsNotEmpty)(),
    (0, class_validator_1.MaxLength)(255),
    __metadata("design:type", String)
], CreateFrequentCallerDto.prototype, "firstName", void 0);
__decorate([
    (0, class_validator_1.ValidateIf)((input) => input.callerType === frequent_caller_type_enum_1.FrequentCallerType.CITIZEN),
    (0, class_validator_1.IsDateString)(),
    __metadata("design:type", String)
], CreateFrequentCallerDto.prototype, "birthDate", void 0);
__decorate([
    (0, class_validator_1.ValidateIf)((input) => input.callerType === frequent_caller_type_enum_1.FrequentCallerType.CITIZEN),
    (0, class_validator_1.IsEnum)(frequent_caller_gender_enum_1.FrequentCallerGender),
    __metadata("design:type", String)
], CreateFrequentCallerDto.prototype, "gender", void 0);
__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.MaxLength)(1024),
    __metadata("design:type", String)
], CreateFrequentCallerDto.prototype, "photoUrl", void 0);
__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.MaxLength)(255),
    __metadata("design:type", String)
], CreateFrequentCallerDto.prototype, "contactName", void 0);
__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.MaxLength)(30),
    __metadata("design:type", String)
], CreateFrequentCallerDto.prototype, "phone", void 0);
__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsEmail)(),
    (0, class_validator_1.MaxLength)(255),
    __metadata("design:type", String)
], CreateFrequentCallerDto.prototype, "email", void 0);
__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.MaxLength)(500),
    __metadata("design:type", String)
], CreateFrequentCallerDto.prototype, "address", void 0);
__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.MaxLength)(255),
    __metadata("design:type", String)
], CreateFrequentCallerDto.prototype, "khoroo", void 0);
__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsInt)(),
    (0, class_validator_1.Min)(0),
    __metadata("design:type", Number)
], CreateFrequentCallerDto.prototype, "callFrequency", void 0);
__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsInt)(),
    (0, class_validator_1.Min)(0),
    __metadata("design:type", Number)
], CreateFrequentCallerDto.prototype, "crimeCallCount", void 0);
__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsInt)(),
    (0, class_validator_1.Min)(0),
    __metadata("design:type", Number)
], CreateFrequentCallerDto.prototype, "incidentCallCount", void 0);
__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsInt)(),
    (0, class_validator_1.Min)(0),
    __metadata("design:type", Number)
], CreateFrequentCallerDto.prototype, "complaintCount", void 0);
__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    __metadata("design:type", String)
], CreateFrequentCallerDto.prototype, "convictionHistory", void 0);
__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    __metadata("design:type", String)
], CreateFrequentCallerDto.prototype, "adminViolationHistory", void 0);
__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    __metadata("design:type", String)
], CreateFrequentCallerDto.prototype, "violationType", void 0);
__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    __metadata("design:type", String)
], CreateFrequentCallerDto.prototype, "followUpAction", void 0);
__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsBoolean)(),
    __metadata("design:type", Boolean)
], CreateFrequentCallerDto.prototype, "hasIssue", void 0);
__decorate([
    (0, class_validator_1.IsOptional)(),
    (0, class_validator_1.IsString)(),
    __metadata("design:type", String)
], CreateFrequentCallerDto.prototype, "notes", void 0);
//# sourceMappingURL=create-frequent-caller.dto.js.map