"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.StrongPassword = StrongPassword;
const class_validator_1 = require("class-validator");
const PASSWORD_REGEX = /^(?=.*[a-z])(?=.*[A-Z])(?=.*\d)(?=.*[^\da-zA-Z]).{10,}$/;
function StrongPassword(validationOptions) {
    return function (object, propertyName) {
        (0, class_validator_1.registerDecorator)({
            name: 'StrongPassword',
            target: object.constructor,
            propertyName,
            options: {
                message: 'Нууц үг дор хаяж 10 тэмдэгт байх ба том үсэг, жижиг үсэг, тоо, тусгай тэмдэгт агуулсан байх ёстой.',
                ...validationOptions,
            },
            validator: {
                validate(value) {
                    if (typeof value !== 'string') {
                        return false;
                    }
                    return PASSWORD_REGEX.test(value);
                },
                defaultMessage(args) {
                    return (args?.constraints?.[0] ??
                        'Нууц үг дор хаяж 10 тэмдэгт байх ба том үсэг, жижиг үсэг, тоо, тусгай тэмдэгт агуулсан байх ёстой.');
                },
            },
        });
    };
}
//# sourceMappingURL=strong-password.decorator.js.map