"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Camera = void 0;
const typeorm_1 = require("typeorm");
const camera_owner_type_enum_1 = require("../enums/camera-owner-type.enum");
const camera_technology_enum_1 = require("../enums/camera-technology.enum");
const camera_status_enum_1 = require("../enums/camera-status.enum");
const decimalTransformer = {
    to: (value) => (typeof value === 'number' ? value : null),
    from: (value) => (typeof value === 'string' ? Number(value) : value ?? null),
};
let Camera = class Camera {
    id;
    name;
    registrationNumber;
    ownerOrganization;
    ownerType;
    contactPerson;
    contactPhone;
    backupPhone;
    address;
    district;
    khoroo;
    technology;
    status;
    resolution;
    retentionDays;
    coverageZone;
    latitude;
    longitude;
    highlight;
    integrateIrec;
    integrateNxWitness;
    linkedCaseCount;
    linkedViolationCount;
    recordingDuration;
    notes;
    createdAt;
    updatedAt;
};
exports.Camera = Camera;
__decorate([
    (0, typeorm_1.PrimaryGeneratedColumn)('uuid'),
    __metadata("design:type", String)
], Camera.prototype, "id", void 0);
__decorate([
    (0, typeorm_1.Column)(),
    __metadata("design:type", String)
], Camera.prototype, "name", void 0);
__decorate([
    (0, typeorm_1.Column)({ nullable: true }),
    __metadata("design:type", String)
], Camera.prototype, "registrationNumber", void 0);
__decorate([
    (0, typeorm_1.Column)({ nullable: true }),
    __metadata("design:type", String)
], Camera.prototype, "ownerOrganization", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'enum', enum: camera_owner_type_enum_1.CameraOwnerType, default: camera_owner_type_enum_1.CameraOwnerType.ORGANIZATION }),
    __metadata("design:type", String)
], Camera.prototype, "ownerType", void 0);
__decorate([
    (0, typeorm_1.Column)({ nullable: true }),
    __metadata("design:type", String)
], Camera.prototype, "contactPerson", void 0);
__decorate([
    (0, typeorm_1.Column)({ nullable: true }),
    __metadata("design:type", String)
], Camera.prototype, "contactPhone", void 0);
__decorate([
    (0, typeorm_1.Column)({ nullable: true }),
    __metadata("design:type", String)
], Camera.prototype, "backupPhone", void 0);
__decorate([
    (0, typeorm_1.Column)({ nullable: true }),
    __metadata("design:type", String)
], Camera.prototype, "address", void 0);
__decorate([
    (0, typeorm_1.Column)({ nullable: true }),
    __metadata("design:type", String)
], Camera.prototype, "district", void 0);
__decorate([
    (0, typeorm_1.Column)({ nullable: true }),
    __metadata("design:type", String)
], Camera.prototype, "khoroo", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'enum', enum: camera_technology_enum_1.CameraTechnology, default: camera_technology_enum_1.CameraTechnology.IP }),
    __metadata("design:type", String)
], Camera.prototype, "technology", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'enum', enum: camera_status_enum_1.CameraStatus, default: camera_status_enum_1.CameraStatus.ACTIVE }),
    __metadata("design:type", String)
], Camera.prototype, "status", void 0);
__decorate([
    (0, typeorm_1.Column)({ nullable: true }),
    __metadata("design:type", String)
], Camera.prototype, "resolution", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'int', default: 30 }),
    __metadata("design:type", Number)
], Camera.prototype, "retentionDays", void 0);
__decorate([
    (0, typeorm_1.Column)({ nullable: true }),
    __metadata("design:type", String)
], Camera.prototype, "coverageZone", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'decimal', precision: 10, scale: 6, nullable: true, transformer: decimalTransformer }),
    __metadata("design:type", Object)
], Camera.prototype, "latitude", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'decimal', precision: 10, scale: 6, nullable: true, transformer: decimalTransformer }),
    __metadata("design:type", Object)
], Camera.prototype, "longitude", void 0);
__decorate([
    (0, typeorm_1.Column)({ default: false }),
    __metadata("design:type", Boolean)
], Camera.prototype, "highlight", void 0);
__decorate([
    (0, typeorm_1.Column)({ default: false }),
    __metadata("design:type", Boolean)
], Camera.prototype, "integrateIrec", void 0);
__decorate([
    (0, typeorm_1.Column)({ default: false }),
    __metadata("design:type", Boolean)
], Camera.prototype, "integrateNxWitness", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'int', default: 0 }),
    __metadata("design:type", Number)
], Camera.prototype, "linkedCaseCount", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'int', default: 0 }),
    __metadata("design:type", Number)
], Camera.prototype, "linkedViolationCount", void 0);
__decorate([
    (0, typeorm_1.Column)({ nullable: true }),
    __metadata("design:type", String)
], Camera.prototype, "recordingDuration", void 0);
__decorate([
    (0, typeorm_1.Column)({ nullable: true }),
    __metadata("design:type", String)
], Camera.prototype, "notes", void 0);
__decorate([
    (0, typeorm_1.CreateDateColumn)(),
    __metadata("design:type", Date)
], Camera.prototype, "createdAt", void 0);
__decorate([
    (0, typeorm_1.UpdateDateColumn)(),
    __metadata("design:type", Date)
], Camera.prototype, "updatedAt", void 0);
exports.Camera = Camera = __decorate([
    (0, typeorm_1.Entity)({ name: 'cameras' })
], Camera);
//# sourceMappingURL=camera.entity.js.map