import { CameraOwnerType } from '../enums/camera-owner-type.enum';
import { CameraTechnology } from '../enums/camera-technology.enum';
import { CameraStatus } from '../enums/camera-status.enum';
export declare class Camera {
    id: string;
    name: string;
    registrationNumber?: string;
    ownerOrganization?: string;
    ownerType: CameraOwnerType;
    contactPerson?: string;
    contactPhone?: string;
    backupPhone?: string;
    address?: string;
    district?: string;
    khoroo?: string;
    technology: CameraTechnology;
    status: CameraStatus;
    resolution?: string;
    retentionDays: number;
    coverageZone?: string;
    latitude?: number | null;
    longitude?: number | null;
    highlight: boolean;
    integrateIrec: boolean;
    integrateNxWitness: boolean;
    linkedCaseCount: number;
    linkedViolationCount: number;
    recordingDuration?: string;
    notes?: string;
    createdAt: Date;
    updatedAt: Date;
}
