"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CamerasService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
const XLSX = __importStar(require("xlsx"));
const camera_entity_1 = require("./entities/camera.entity");
const camera_owner_type_enum_1 = require("./enums/camera-owner-type.enum");
const camera_status_enum_1 = require("./enums/camera-status.enum");
const camera_technology_enum_1 = require("./enums/camera-technology.enum");
let CamerasService = class CamerasService {
    camerasRepository;
    constructor(camerasRepository) {
        this.camerasRepository = camerasRepository;
    }
    create(createCameraDto) {
        const entity = this.camerasRepository.create({
            district: createCameraDto.district ?? 'Налайх',
            retentionDays: createCameraDto.retentionDays ?? 30,
            ...createCameraDto,
        });
        return this.camerasRepository.save(entity);
    }
    findAll(filter) {
        const where = {};
        if (filter?.ownerType) {
            where.ownerType = filter.ownerType;
        }
        if (filter?.status) {
            where.status = filter.status;
        }
        return this.camerasRepository.find({ where, order: { name: 'ASC' } });
    }
    async findOne(id) {
        const entity = await this.camerasRepository.findOne({ where: { id } });
        if (!entity) {
            throw new common_1.NotFoundException('Камерийн бүртгэл олдсонгүй.');
        }
        return entity;
    }
    async update(id, updateCameraDto) {
        const entity = await this.findOne(id);
        Object.assign(entity, updateCameraDto);
        return this.camerasRepository.save(entity);
    }
    async remove(id) {
        const entity = await this.findOne(id);
        await this.camerasRepository.remove(entity);
        return { deleted: true };
    }
    async importFromExcel(buffer) {
        const workbook = XLSX.read(buffer, { type: 'buffer' });
        const sheet = workbook.Sheets[workbook.SheetNames[0]];
        if (!sheet) {
            return { imported: 0 };
        }
        const rawRows = XLSX.utils.sheet_to_json(sheet, {
            defval: null,
            raw: false,
            blankrows: false,
        });
        const rows = rawRows
            .map((row) => this.mapRowToDto(row))
            .filter((row) => Boolean(row));
        if (!rows.length) {
            return { imported: 0 };
        }
        const entities = this.camerasRepository.create(rows);
        await this.camerasRepository.save(entities);
        return { imported: rows.length };
    }
    async exportAsExcel(filter) {
        const workbook = XLSX.utils.book_new();
        const isTemplate = filter?.template ?? false;
        const aoa = isTemplate
            ? this.buildTemplateSheet()
            : this.buildSheetData(await this.findAll({ ownerType: filter?.ownerType, status: filter?.status }));
        const sheet = XLSX.utils.aoa_to_sheet(aoa);
        XLSX.utils.book_append_sheet(workbook, sheet, isTemplate ? 'Template' : 'Cameras');
        return XLSX.write(workbook, { type: 'buffer', bookType: 'xlsx' });
    }
    buildSheetData(data) {
        const header = this.getTemplateHeader();
        const rows = data.map((item) => [
            item.khoroo ?? '',
            this.formatOwnerType(item.ownerType, true),
            item.registrationNumber ?? '',
            item.name ?? '',
            item.address ?? '',
            item.contactPhone ?? '',
            item.linkedCaseCount ?? 0,
            item.linkedViolationCount ?? 0,
            item.longitude ?? '',
            item.latitude ?? '',
            item.highlight ? 'Тийм' : 'Үгүй',
            `${item.retentionDays ?? 0} хоног`,
            item.integrateIrec ? 'Тийм' : 'Үгүй',
            item.integrateNxWitness ? 'Тийм' : 'Үгүй',
        ]);
        return [header, ...rows];
    }
    buildTemplateSheet() {
        const header = this.getTemplateHeader();
        const sampleRow = [
            '5-р хороо',
            'ААН',
            '1234567',
            'Smart Systems LLC',
            'Налайх, 5-р хороо, 12-23',
            '99001234',
            0,
            0,
            '107.123456',
            '47.987654',
            'Тийм',
            '30-с дээш хоног',
            'Тийм',
            'Үгүй',
        ];
        return [header, sampleRow];
    }
    getTemplateHeader() {
        return [
            'Хороо',
            'Иргэн, ААНБ',
            'Регистр',
            'Иргэн байгууллагын нэр',
            'Хаяг',
            'Утас',
            'Хөдөлгөөнт',
            'Чигийн',
            'Уртраг',
            'Өргөрөг',
            'Шар тэмдэг суурилуулах ан эсэх',
            'Камер бичлэг хадгалах хугацаа',
            'IREX систем суурилуулах боломжтой эсэх',
            'NX WITNESS систем суурилуулах боломжтой эсэх',
        ];
    }
    mapRowToDto(row) {
        const normalized = Object.keys(row).reduce((acc, key) => {
            acc[key.trim().toLowerCase()] = row[key];
            return acc;
        }, {});
        const name = this.getString(normalized['иргэн байгууллагын нэр'] ??
            normalized['байгууллагын нэр'] ??
            normalized['камерын нэр'] ??
            normalized['name']);
        if (!name) {
            return null;
        }
        const dto = {
            name,
            ownerType: this.parseOwnerType(normalized['иргэн/байгууллага'] ?? normalized['иргэн, аанб'] ?? normalized['төрөл']) ?? camera_owner_type_enum_1.CameraOwnerType.ORGANIZATION,
            technology: this.parseTechnology(normalized['камерын төрөл'] ?? normalized['камерын технологи']) ??
                camera_technology_enum_1.CameraTechnology.IP,
            status: this.parseStatus(normalized['төлөв']) ?? camera_status_enum_1.CameraStatus.ACTIVE,
            district: this.getString(normalized['дүүрэг']) ?? 'Налайх',
            khoroo: this.getString(normalized['хороо']) ?? undefined,
            address: this.getString(normalized['хаяг']) ?? undefined,
            registrationNumber: this.getString(normalized['регистри'] ??
                normalized['регистер'] ??
                normalized['регистрын дугаар'] ??
                normalized['регистр']) ?? undefined,
            contactPhone: this.getString(normalized['утас']) ?? undefined,
            backupPhone: this.getString(normalized['хөдөлгөөнт'] ?? normalized['нэмэлт утас'] ?? normalized['утас2']) ?? undefined,
            resolution: this.getString(normalized['нягтаршил']) ?? undefined,
            retentionDays: this.getNumber(normalized['бичлэг хадгалах хугацаа'] ??
                normalized['камер бичлэг хадгалах хугацаа'] ??
                normalized['хадгалах хоног']),
            coverageZone: this.getString(normalized['хамаарах бүс']) ?? undefined,
            contactPerson: this.getString(normalized['эзэмшигч байгууллага'] ?? normalized['иргэн байгууллагын нэр']) ?? undefined,
            ownerOrganization: this.getString(normalized['эзэмшигч байгууллага'] ?? normalized['иргэн байгууллагын нэр']) ?? undefined,
            highlight: this.getBoolean(normalized['шар тэмдэг'] ??
                normalized['шар тэмдэг суурилуулах ан эсэх'] ??
                normalized['шар тэмдэг суурилуулах']) ?? false,
            integrateIrec: this.getBoolean(normalized['irec системтэй холбох'] ??
                normalized['irec систем суурилуулах боломжтой эсэх'] ??
                normalized['irec']) ?? false,
            integrateNxWitness: this.getBoolean(normalized['nx witness системтэй холбох'] ??
                normalized['nx witness систем суурилуулах боломжтой эсэх'] ??
                normalized['nx witness']),
            latitude: this.getNumber(normalized['өргөрөг'] ?? normalized['latitude']),
            longitude: this.getNumber(normalized['уртраг'] ?? normalized['longitude']),
            recordingDuration: this.getString(normalized['бичлэгийн хугацаа']) ?? undefined,
            notes: this.getString(normalized['тэмдэглэл']) ?? undefined,
        };
        return dto;
    }
    parseOwnerType(value) {
        const normalized = this.getString(value)?.toLowerCase();
        if (!normalized)
            return undefined;
        if (['нийтийн', 'public'].includes(normalized))
            return camera_owner_type_enum_1.CameraOwnerType.PUBLIC;
        if (['замын', 'road'].includes(normalized))
            return camera_owner_type_enum_1.CameraOwnerType.ROAD;
        if (['хувийн', 'иргэн', 'private'].includes(normalized))
            return camera_owner_type_enum_1.CameraOwnerType.PRIVATE;
        if (['байгууллага', 'organization', 'аан', 'aan'].includes(normalized))
            return camera_owner_type_enum_1.CameraOwnerType.ORGANIZATION;
        return undefined;
    }
    parseTechnology(value) {
        const normalized = this.getString(value)?.toLowerCase();
        if (!normalized)
            return undefined;
        if (normalized.includes('analog') || normalized.includes('аналог'))
            return camera_technology_enum_1.CameraTechnology.ANALOG;
        if (normalized.includes('hybrid'))
            return camera_technology_enum_1.CameraTechnology.HYBRID;
        if (normalized.includes('ip'))
            return camera_technology_enum_1.CameraTechnology.IP;
        return undefined;
    }
    parseStatus(value) {
        const normalized = this.getString(value)?.toLowerCase();
        if (!normalized)
            return undefined;
        if (['active', 'идэвхтэй'].includes(normalized))
            return camera_status_enum_1.CameraStatus.ACTIVE;
        if (['inactive', 'идэвхгүй'].includes(normalized))
            return camera_status_enum_1.CameraStatus.INACTIVE;
        if (['maintenance', 'засвартай'].includes(normalized))
            return camera_status_enum_1.CameraStatus.MAINTENANCE;
        return undefined;
    }
    formatOwnerType(type, shortLabel = false) {
        if (shortLabel) {
            switch (type) {
                case camera_owner_type_enum_1.CameraOwnerType.PUBLIC:
                    return 'Нийтийн';
                case camera_owner_type_enum_1.CameraOwnerType.ROAD:
                    return 'Замын';
                case camera_owner_type_enum_1.CameraOwnerType.PRIVATE:
                    return 'Иргэн';
                default:
                    return 'ААН';
            }
        }
        switch (type) {
            case camera_owner_type_enum_1.CameraOwnerType.PUBLIC:
                return 'Нийтийн';
            case camera_owner_type_enum_1.CameraOwnerType.ROAD:
                return 'Замын';
            case camera_owner_type_enum_1.CameraOwnerType.PRIVATE:
                return 'Хувийн';
            default:
                return 'Байгууллагын';
        }
    }
    formatTechnology(type) {
        if (type === camera_technology_enum_1.CameraTechnology.ANALOG)
            return 'Аналог';
        if (type === camera_technology_enum_1.CameraTechnology.HYBRID)
            return 'Гибрид';
        return 'IP';
    }
    formatStatus(status) {
        if (status === camera_status_enum_1.CameraStatus.MAINTENANCE)
            return 'Засвартай';
        if (status === camera_status_enum_1.CameraStatus.INACTIVE)
            return 'Идэвхгүй';
        return 'Идэвхтэй';
    }
    getString(value) {
        if (value === null || value === undefined)
            return undefined;
        const str = String(value).trim();
        return str.length ? str : undefined;
    }
    getNumber(value) {
        if (value === null || value === undefined || value === '')
            return undefined;
        const num = Number(value);
        return Number.isFinite(num) ? num : undefined;
    }
    getBoolean(value) {
        if (typeof value === 'boolean')
            return value;
        const normalized = this.getString(value)?.toLowerCase();
        if (!normalized)
            return false;
        return ['тийм', 'yes', 'true', 'y'].includes(normalized);
    }
};
exports.CamerasService = CamerasService;
exports.CamerasService = CamerasService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(camera_entity_1.Camera)),
    __metadata("design:paramtypes", [typeorm_2.Repository])
], CamerasService);
//# sourceMappingURL=cameras.service.js.map