import { Repository } from 'typeorm';
import { Camera } from './entities/camera.entity';
import { CreateCameraDto } from './dto/create-camera.dto';
import { UpdateCameraDto } from './dto/update-camera.dto';
import { CameraOwnerType } from './enums/camera-owner-type.enum';
import { CameraStatus } from './enums/camera-status.enum';
export declare class CamerasService {
    private readonly camerasRepository;
    constructor(camerasRepository: Repository<Camera>);
    create(createCameraDto: CreateCameraDto): Promise<Camera>;
    findAll(filter?: {
        ownerType?: CameraOwnerType;
        status?: CameraStatus;
    }): Promise<Camera[]>;
    findOne(id: string): Promise<Camera>;
    update(id: string, updateCameraDto: UpdateCameraDto): Promise<Camera>;
    remove(id: string): Promise<{
        deleted: boolean;
    }>;
    importFromExcel(buffer: Buffer): Promise<{
        imported: number;
    }>;
    exportAsExcel(filter?: {
        ownerType?: CameraOwnerType;
        status?: CameraStatus;
        template?: boolean;
    }): Promise<any>;
    private buildSheetData;
    private buildTemplateSheet;
    private getTemplateHeader;
    private mapRowToDto;
    private parseOwnerType;
    private parseTechnology;
    private parseStatus;
    private formatOwnerType;
    private formatTechnology;
    private formatStatus;
    private getString;
    private getNumber;
    private getBoolean;
}
