"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CamerasController = void 0;
const common_1 = require("@nestjs/common");
const platform_express_1 = require("@nestjs/platform-express");
const cameras_service_1 = require("./cameras.service");
const create_camera_dto_1 = require("./dto/create-camera.dto");
const update_camera_dto_1 = require("./dto/update-camera.dto");
const filter_camera_dto_1 = require("./dto/filter-camera.dto");
let CamerasController = class CamerasController {
    camerasService;
    constructor(camerasService) {
        this.camerasService = camerasService;
    }
    create(createCameraDto) {
        return this.camerasService.create(createCameraDto);
    }
    findAll(filter) {
        return this.camerasService.findAll(filter);
    }
    findOne(id) {
        return this.camerasService.findOne(id);
    }
    update(id, updateCameraDto) {
        return this.camerasService.update(id, updateCameraDto);
    }
    remove(id) {
        return this.camerasService.remove(id);
    }
    import(file) {
        if (!file) {
            return { imported: 0 };
        }
        return this.camerasService.importFromExcel(file.buffer);
    }
    async export(res, filter, template) {
        const { template: filterTemplate, ...rest } = filter;
        const isTemplate = template === 'true' || filterTemplate === 'true';
        const buffer = await this.camerasService.exportAsExcel({ ...rest, template: isTemplate });
        const suffix = isTemplate ? 'template' : 'data';
        const fileName = `cameras_${suffix}_${new Date().toISOString().split('T')[0]}.xlsx`;
        res.setHeader('Content-Type', 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        res.setHeader('Content-Disposition', `attachment; filename="${fileName}"`);
        res.send(buffer);
    }
};
exports.CamerasController = CamerasController;
__decorate([
    (0, common_1.Post)(),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [create_camera_dto_1.CreateCameraDto]),
    __metadata("design:returntype", void 0)
], CamerasController.prototype, "create", null);
__decorate([
    (0, common_1.Get)(),
    __param(0, (0, common_1.Query)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [filter_camera_dto_1.FilterCameraDto]),
    __metadata("design:returntype", void 0)
], CamerasController.prototype, "findAll", null);
__decorate([
    (0, common_1.Get)(':id'),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], CamerasController.prototype, "findOne", null);
__decorate([
    (0, common_1.Patch)(':id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, update_camera_dto_1.UpdateCameraDto]),
    __metadata("design:returntype", void 0)
], CamerasController.prototype, "update", null);
__decorate([
    (0, common_1.Delete)(':id'),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], CamerasController.prototype, "remove", null);
__decorate([
    (0, common_1.Post)('import'),
    (0, common_1.UseInterceptors)((0, platform_express_1.FileInterceptor)('file')),
    __param(0, (0, common_1.UploadedFile)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", void 0)
], CamerasController.prototype, "import", null);
__decorate([
    (0, common_1.Get)('export/excel'),
    __param(0, (0, common_1.Res)({ passthrough: true })),
    __param(1, (0, common_1.Query)()),
    __param(2, (0, common_1.Query)('template')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, filter_camera_dto_1.FilterCameraDto, String]),
    __metadata("design:returntype", Promise)
], CamerasController.prototype, "export", null);
exports.CamerasController = CamerasController = __decorate([
    (0, common_1.Controller)('cameras'),
    __metadata("design:paramtypes", [cameras_service_1.CamerasService])
], CamerasController);
//# sourceMappingURL=cameras.controller.js.map