import type { Response } from 'express';
import { CamerasService } from './cameras.service';
import { CreateCameraDto } from './dto/create-camera.dto';
import { UpdateCameraDto } from './dto/update-camera.dto';
import { FilterCameraDto } from './dto/filter-camera.dto';
export declare class CamerasController {
    private readonly camerasService;
    constructor(camerasService: CamerasService);
    create(createCameraDto: CreateCameraDto): Promise<import("./entities/camera.entity").Camera>;
    findAll(filter: FilterCameraDto): Promise<import("./entities/camera.entity").Camera[]>;
    findOne(id: string): Promise<import("./entities/camera.entity").Camera>;
    update(id: string, updateCameraDto: UpdateCameraDto): Promise<import("./entities/camera.entity").Camera>;
    remove(id: string): Promise<{
        deleted: boolean;
    }>;
    import(file?: Express.Multer.File): Promise<{
        imported: number;
    }> | {
        imported: number;
    };
    export(res: Response, filter: FilterCameraDto, template?: string): Promise<void>;
}
