import { ConfigService } from '@nestjs/config';
import { Strategy } from 'passport-jwt';
import { UsersService } from '../../users/users.service';
declare const JwtStrategy_base: new (...args: [opt: import("passport-jwt").StrategyOptionsWithRequest] | [opt: import("passport-jwt").StrategyOptionsWithoutRequest]) => Strategy & {
    validate(...args: any[]): unknown;
};
export declare class JwtStrategy extends JwtStrategy_base {
    private readonly configService;
    private readonly usersService;
    constructor(configService: ConfigService, usersService: UsersService);
    validate(payload: {
        sub: string;
    }): Promise<{
        id: string;
        email: string;
        firstName: string;
        lastName: string;
        phone?: string;
        rank?: string;
        unit?: string;
        role: import("../../users/enums/user-role.enum").UserRole;
        isActive: boolean;
        passwordChangedAt?: Date;
        passwordExpiresAt?: Date;
        lastLoginAt?: Date;
        lastLoginIp?: string;
        lastLoginDeviceId?: string;
        devices?: import("../entities/user-device.entity").UserDevice[];
        createdAt: Date;
        updatedAt: Date;
    }>;
}
export {};
