"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PasswordResetService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
const password_reset_token_entity_1 = require("./entities/password-reset-token.entity");
const users_service_1 = require("../users/users.service");
const mail_service_1 = require("../mail/mail.service");
const crypto_1 = require("crypto");
const RESET_TOKEN_TTL_MINUTES = 30;
let PasswordResetService = class PasswordResetService {
    tokensRepository;
    usersService;
    mailService;
    constructor(tokensRepository, usersService, mailService) {
        this.tokensRepository = tokensRepository;
        this.usersService = usersService;
        this.mailService = mailService;
    }
    async requestReset(email) {
        const user = await this.usersService.findByEmail(email);
        if (!user || !user.isActive) {
            return {
                message: 'Хэрэв и-мэйл бүртгэлтэй бол сэргээх заавар илгээгдлээ.',
            };
        }
        await this.invalidateExistingTokens(user.id);
        const plainToken = (0, crypto_1.randomBytes)(24).toString('hex');
        const tokenHash = this.hashToken(plainToken);
        const expiresAt = new Date(Date.now() + RESET_TOKEN_TTL_MINUTES * 60 * 1000);
        await this.tokensRepository.save(this.tokensRepository.create({ user, tokenHash, expiresAt }));
        await this.mailService.logPasswordResetEmail({
            to: user.email,
            token: plainToken,
            expiresAt,
        });
        return {
            message: 'Хэрэв и-мэйл бүртгэлтэй бол сэргээх заавар илгээгдлээ.',
            expiresAt,
        };
    }
    async resetPassword(token, newPassword) {
        const tokenHash = this.hashToken(token);
        const tokenEntity = await this.tokensRepository.findOne({
            where: {
                tokenHash,
                usedAt: (0, typeorm_2.IsNull)(),
            },
            relations: { user: true },
        });
        if (!tokenEntity) {
            throw new common_1.BadRequestException('Сэргээх холбоос хүчингүй байна.');
        }
        if (tokenEntity.expiresAt.getTime() < Date.now()) {
            throw new common_1.BadRequestException('Сэргээх холбоосны хугацаа дууссан.');
        }
        await this.usersService.update(tokenEntity.user.id, {
            password: newPassword,
        });
        tokenEntity.usedAt = new Date();
        await this.tokensRepository.save(tokenEntity);
        return { message: 'Нууц үг амжилттай солигдлоо.' };
    }
    async invalidateExistingTokens(userId) {
        await this.tokensRepository.update({ user: { id: userId } }, { usedAt: new Date() });
    }
    hashToken(token) {
        return (0, crypto_1.createHash)('sha256').update(token).digest('hex');
    }
};
exports.PasswordResetService = PasswordResetService;
exports.PasswordResetService = PasswordResetService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(password_reset_token_entity_1.PasswordResetToken)),
    __metadata("design:paramtypes", [typeorm_2.Repository,
        users_service_1.UsersService,
        mail_service_1.MailService])
], PasswordResetService);
//# sourceMappingURL=password-reset.service.js.map