import { Repository } from 'typeorm';
import { PasswordResetToken } from './entities/password-reset-token.entity';
import { UsersService } from '../users/users.service';
import { MailService } from '../mail/mail.service';
export declare class PasswordResetService {
    private readonly tokensRepository;
    private readonly usersService;
    private readonly mailService;
    constructor(tokensRepository: Repository<PasswordResetToken>, usersService: UsersService, mailService: MailService);
    requestReset(email: string): Promise<{
        message: string;
        expiresAt?: undefined;
    } | {
        message: string;
        expiresAt: Date;
    }>;
    resetPassword(token: string, newPassword: string): Promise<{
        message: string;
    }>;
    private invalidateExistingTokens;
    private hashToken;
}
