"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AuthService = void 0;
const common_1 = require("@nestjs/common");
const jwt_1 = require("@nestjs/jwt");
const bcrypt = __importStar(require("bcrypt"));
const users_service_1 = require("../users/users.service");
const auth_tracking_service_1 = require("./auth-tracking.service");
let AuthService = class AuthService {
    usersService;
    jwtService;
    authTracking;
    constructor(usersService, jwtService, authTracking) {
        this.usersService = usersService;
        this.jwtService = jwtService;
        this.authTracking = authTracking;
    }
    async validateUser(email, password, context) {
        const normalizedEmail = email.trim().toLowerCase();
        const user = await this.usersService.findByEmail(email);
        if (!user || !user.isActive) {
            await this.authTracking.logAttempt({
                user: user ?? undefined,
                email: normalizedEmail,
                success: false,
                failureReason: user ? 'ACCOUNT_INACTIVE' : 'NOT_FOUND',
                context,
            });
            throw new common_1.UnauthorizedException('Нэвтрэх мэдээлэл буруу байна.');
        }
        const isPasswordValid = await bcrypt.compare(password, user.password);
        if (!isPasswordValid) {
            await this.authTracking.logAttempt({
                user,
                email: normalizedEmail,
                success: false,
                failureReason: 'INVALID_PASSWORD',
                context,
            });
            throw new common_1.UnauthorizedException('Нэвтрэх мэдээлэл буруу байна.');
        }
        if (user.passwordExpiresAt && user.passwordExpiresAt.getTime() < Date.now()) {
            await this.authTracking.logAttempt({
                user,
                email: normalizedEmail,
                success: false,
                failureReason: 'PASSWORD_EXPIRED',
                context,
            });
            throw new common_1.UnauthorizedException('Нууц үгний хугацаа дууссан. Сэргээх үйлдэл хийнэ үү.');
        }
        const { password: _password, ...sanitizedUser } = user;
        return sanitizedUser;
    }
    async login(user, context) {
        const payload = { sub: user.id, email: user.email, role: user.role };
        const response = {
            accessToken: await this.jwtService.signAsync(payload),
            user,
        };
        if (user?.id) {
            try {
                const fullUser = await this.usersService.findOne(user.id);
                await this.authTracking.recordSuccessfulLogin(fullUser, context);
            }
            catch (error) {
                await this.authTracking.logAttempt({
                    user: { ...user },
                    email: user.email,
                    success: true,
                    failureReason: 'LOGIN_RECORDED_WITH_ERRORS',
                    context,
                });
            }
        }
        return response;
    }
};
exports.AuthService = AuthService;
exports.AuthService = AuthService = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [users_service_1.UsersService,
        jwt_1.JwtService,
        auth_tracking_service_1.AuthTrackingService])
], AuthService);
//# sourceMappingURL=auth.service.js.map