import { JwtService } from '@nestjs/jwt';
import { UsersService } from '../users/users.service';
import { User } from '../users/entities/user.entity';
import { AuthTrackingService, LoginContext } from './auth-tracking.service';
export declare class AuthService {
    private readonly usersService;
    private readonly jwtService;
    private readonly authTracking;
    constructor(usersService: UsersService, jwtService: JwtService, authTracking: AuthTrackingService);
    validateUser(email: string, password: string, context?: LoginContext): Promise<User>;
    login(user: User, context?: LoginContext): Promise<{
        accessToken: string;
        user: User;
    }>;
}
