import { Request } from 'express';
import { AuthService } from './auth.service';
import { User } from '../users/entities/user.entity';
import { LoginContext } from './auth-tracking.service';
import { PasswordResetService } from './password-reset.service';
import { PasswordResetRequestDto } from './dto/password-reset-request.dto';
import { PasswordResetConfirmDto } from './dto/password-reset-confirm.dto';
type AuthenticatedRequest = Request & {
    user: User;
    authContext?: LoginContext;
};
export declare class AuthController {
    private readonly authService;
    private readonly passwordResetService;
    constructor(authService: AuthService, passwordResetService: PasswordResetService);
    login(req: AuthenticatedRequest): Promise<{
        accessToken: string;
        user: User;
    }>;
    me(req: AuthenticatedRequest): Express.User & User;
    requestReset(dto: PasswordResetRequestDto): Promise<{
        message: string;
        expiresAt?: undefined;
    } | {
        message: string;
        expiresAt: Date;
    }>;
    confirmReset(dto: PasswordResetConfirmDto): Promise<{
        message: string;
    }>;
}
export {};
