"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AuthTrackingService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
const auth_log_entity_1 = require("./entities/auth-log.entity");
const user_device_entity_1 = require("./entities/user-device.entity");
const user_entity_1 = require("../users/entities/user.entity");
const crypto_1 = require("crypto");
let AuthTrackingService = class AuthTrackingService {
    authLogRepository;
    userDeviceRepository;
    usersRepository;
    constructor(authLogRepository, userDeviceRepository, usersRepository) {
        this.authLogRepository = authLogRepository;
        this.userDeviceRepository = userDeviceRepository;
        this.usersRepository = usersRepository;
    }
    async logAttempt(args) {
        const { user, email, success, failureReason, context } = args;
        const log = this.authLogRepository.create({
            user,
            email,
            success,
            failureReason,
            ipAddress: context?.ipAddress,
            userAgent: context?.userAgent,
            deviceId: context?.deviceId ?? this.buildFallbackDeviceId(context),
        });
        await this.authLogRepository.save(log);
    }
    async recordSuccessfulLogin(user, context) {
        const now = new Date();
        const deviceId = context?.deviceId ?? this.buildFallbackDeviceId(context);
        await this.logAttempt({ user, email: user.email, success: true, context });
        if (deviceId) {
            await this.userDeviceRepository.upsert({
                user: { id: user.id },
                deviceId,
                deviceName: context?.deviceName,
                platform: context?.platform,
                userAgent: context?.userAgent,
                lastIp: context?.ipAddress,
                lastUsedAt: now,
            }, ['user', 'deviceId']);
        }
        await this.usersRepository.update(user.id, {
            lastLoginAt: now,
            lastLoginIp: context?.ipAddress,
            lastLoginDeviceId: deviceId,
        });
    }
    buildFallbackDeviceId(context) {
        if (!context?.userAgent && !context?.ipAddress) {
            return undefined;
        }
        const fingerprint = `${context?.userAgent ?? 'ua'}|${context?.ipAddress ?? 'ip'}`;
        return (0, crypto_1.createHash)('sha256').update(fingerprint).digest('hex');
    }
};
exports.AuthTrackingService = AuthTrackingService;
exports.AuthTrackingService = AuthTrackingService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(auth_log_entity_1.AuthLog)),
    __param(1, (0, typeorm_1.InjectRepository)(user_device_entity_1.UserDevice)),
    __param(2, (0, typeorm_1.InjectRepository)(user_entity_1.User)),
    __metadata("design:paramtypes", [typeorm_2.Repository,
        typeorm_2.Repository,
        typeorm_2.Repository])
], AuthTrackingService);
//# sourceMappingURL=auth-tracking.service.js.map