import { Repository } from 'typeorm';
import { AuthLog } from './entities/auth-log.entity';
import { UserDevice } from './entities/user-device.entity';
import { User } from '../users/entities/user.entity';
export interface LoginContext {
    ipAddress?: string;
    userAgent?: string;
    deviceId?: string;
    deviceName?: string;
    platform?: string;
}
export declare class AuthTrackingService {
    private readonly authLogRepository;
    private readonly userDeviceRepository;
    private readonly usersRepository;
    constructor(authLogRepository: Repository<AuthLog>, userDeviceRepository: Repository<UserDevice>, usersRepository: Repository<User>);
    logAttempt(args: {
        user?: User | null;
        email?: string;
        success: boolean;
        failureReason?: string;
        context?: LoginContext;
    }): Promise<void>;
    recordSuccessfulLogin(user: User, context?: LoginContext): Promise<void>;
    private buildFallbackDeviceId;
}
